﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Drawing.Printing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;


namespace AZVIC.Ei8htPOS.WebUI.Admin.Helpers
{
    public class ReceiptPrinterHelper
    {
        static Orders _order;
        static string _remarks;
        public void PrintReceipt(Orders Order)
        {
            _order = Order;
            //while (WebSession.CheckPrinterAssigned())
            //{
            //    using (PrintDocument pd = new PrintDocument())
            //    {
            //        PrintDialog dialogPrint = new PrintDialog();
            //        dialogPrint.AllowPrintToFile = true;
            //        dialogPrint.AllowSomePages = true;
            //        dialogPrint.PrinterSettings.MinimumPage = 1;
            //        dialogPrint.PrinterSettings.MaximumPage = 1;
            //        dialogPrint.PrinterSettings.FromPage = 1;
            //        dialogPrint.PrinterSettings.ToPage = 1;
            //        dialogPrint.Document = pd;
            //        pd.PrintPage += new PrintPageEventHandler(pd_PrintPage);
            //        pd.PrinterSettings.PrinterName = Properties.Settings.Default.InvoicePrinter;
            //        pd.Print();
            //        break;
            //    }
            //}
        }

        private void pd_PrintPage(object sender, PrintPageEventArgs ev)
        {
            Graphics graphics = ev.Graphics;
            Brush BlackColor = Brushes.Black;
            Font Headlinefont = new Font("Times New Roman", 18, FontStyle.Regular, GraphicsUnit.Point);
            Font TitleFont = new Font("Times New Roman", 12, FontStyle.Bold, GraphicsUnit.Point);
            Font TableHeaderFont = new Font("Times New Roman", 10, FontStyle.Regular, GraphicsUnit.Point);
            Font ParagraphFont = new Font("Times New Roman", 9, FontStyle.Regular, GraphicsUnit.Point);
            Pen dashStyle = new Pen(Brushes.Black) { DashStyle = System.Drawing.Drawing2D.DashStyle.Dot };

            // Create a StringFormat object with the each line of text, and the block 
            // of text centered on the page.
            StringFormat stringFormat = new StringFormat();
            stringFormat.Alignment = StringAlignment.Far;
            stringFormat.LineAlignment = StringAlignment.Far;

            int LineHeight = 19;
            int startX = 45;
            int startY = 0;
            int Offset = 10;
            graphics.DrawString("ELEVEN & O PTE. LTD.", TitleFont, BlackColor, startX, startY);
            startX = Offset + 25;
            startY = 25;
            graphics.DrawString("110 Mackenzie Road,Singapore-228708", ParagraphFont, BlackColor, startX, startY);

            startX = 77;
            startY = 50;
            graphics.DrawString("RECEIPT", Headlinefont, BlackColor, startX, startY);

            graphics.DrawLine(dashStyle, new Point(Offset, 90), new Point(287, 90));
            startX = Offset;
            startY = 100;
            graphics.DrawString("Cashier", ParagraphFont, BlackColor, startX, startY);
            startX = 114;
            graphics.DrawString(WebSession.CurrentAdminUser.FirstName.ToString(), ParagraphFont, BlackColor, startX, startY);

            startX = Offset;
            startY += LineHeight;
            graphics.DrawString("Date", ParagraphFont, BlackColor, startX, startY);
            startX = 114;
            graphics.DrawString(DateTime.Now.Date.ToShortDateString(), ParagraphFont, BlackColor, startX, startY);

            startX = Offset;
            startY += LineHeight;
            graphics.DrawString("Time", ParagraphFont, BlackColor, startX, startY);
            startX = 114;
            graphics.DrawString(DateTime.Now.ToString("hh:mm ss tt"), ParagraphFont, BlackColor, startX, startY);

            startY += LineHeight + 10;
            graphics.DrawLine(dashStyle, new Point(Offset, startY), new Point(287, startY));

            startX = Offset;
            startY += LineHeight;
            graphics.DrawString("Cust. Name", ParagraphFont, BlackColor, startX, startY);
            startX = 114;
            graphics.DrawString(_order.FirstName, ParagraphFont, BlackColor, startX, startY);

            startX = Offset;
            startY += LineHeight;
            graphics.DrawString("Receipt #", ParagraphFont, BlackColor, startX, startY);
            startX = 114;
            graphics.DrawString(OrdersBL.GetItem(_order.UniqueID, Guid.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue).OrderNumber.ToString(), ParagraphFont, BlackColor, startX, startY);

            startX = Offset;
            startY += LineHeight;
            graphics.DrawString("Table #", ParagraphFont, BlackColor, startX, startY);
            startX = 114;
            graphics.DrawString(WebSession.CurrentOrders.TableNumber, ParagraphFont, BlackColor, startX, startY);

            startY += LineHeight + 10;
            graphics.DrawLine(dashStyle, new Point(Offset, startY), new Point(287, startY));

            startX = Offset;
            startY += LineHeight;
            graphics.DrawString("Item", TableHeaderFont, BlackColor, startX, startY);

            startX = 160;
            graphics.DrawString("Qty", TableHeaderFont, BlackColor, startX, startY);

            startX = 200;
            graphics.DrawString("Price", TableHeaderFont, BlackColor, startX, startY);

            startX = 245;
            graphics.DrawString("Total", TableHeaderFont, BlackColor, startX, startY);

            startY += LineHeight + 10;
            string ItemName, Qty, Price, TotalPrice;
            graphics.DrawLine(dashStyle, new Point(Offset, startY), new Point(287, startY));

            //int spacing = 8;
            startY += LineHeight;
            Rectangle rect2;
            foreach (OrdersDetails orderdetail in _order.OrdersDetailsList)
            {
                ItemName = orderdetail.ProductName.Count() > 30 ? orderdetail.ProductName.Substring(0, 30) + ".." : orderdetail.ProductName;
                Qty = orderdetail.Quantity.ToString();
                Price = orderdetail.UnitPrice.ToString("0.00");
                TotalPrice = orderdetail.OrderPrice.ToString("0.00");
                startX = Offset;
                graphics.DrawString(ItemName, ParagraphFont, BlackColor, startX, startY);
                startX += 160;
                graphics.DrawString(Qty, ParagraphFont, BlackColor, startX, startY);
                startX += 20;
                rect2 = new Rectangle(186, startY - 4, 45, LineHeight);
                graphics.DrawString(Price, ParagraphFont, BlackColor, rect2, stringFormat);
                startX += 47;
                rect2 = new Rectangle(236, startY - 4, 45, LineHeight);
                graphics.DrawString(Price, ParagraphFont, BlackColor, rect2, stringFormat);
                startY += LineHeight;
            }

            startY += 10;
            graphics.DrawLine(dashStyle, new Point(Offset, startY), new Point(287, startY));


            startX = 90;
            startY += LineHeight;
            graphics.DrawString("Sub Total", ParagraphFont, BlackColor, startX, startY);
            Rectangle rect1 = new Rectangle(236, startY, 45, LineHeight);
            graphics.DrawString(_order.SubTotal.ToString("$ 0.00"), ParagraphFont, BlackColor, rect1, stringFormat);

            if (_order.Discount != 0.00M)
            {
                startX = 90;
                startY += LineHeight;
                graphics.DrawString("Item Discounts", ParagraphFont, BlackColor, startX, startY);
                rect1 = new Rectangle(236, startY, 45, LineHeight);
                graphics.DrawString(_order.Discount.ToString("$ 0.00"), ParagraphFont, BlackColor, rect1, stringFormat);
            }

            if (_order.HappyHoursDiscount != 0.00M)
            {
                startX = 90;
                startY += LineHeight;
                graphics.DrawString("Happy Hour Disc.", ParagraphFont, BlackColor, startX, startY);
                rect1 = new Rectangle(236, startY, 45, LineHeight);
                graphics.DrawString(_order.HappyHoursDiscount.ToString("$ 0.00"), ParagraphFont, BlackColor, rect1, stringFormat);
            }

            if (_order.TotalDiscount != 0.00M)
            {
                startX = 90;
                startY += LineHeight;
                graphics.DrawString("Total Transn. Disc.", ParagraphFont, BlackColor, startX, startY);
                rect1 = new Rectangle(236, startY, 45, LineHeight);
                graphics.DrawString(_order.TotalDiscount.ToString("$ 0.00"), ParagraphFont, BlackColor, rect1, stringFormat);
            }

            startX = 90;
            startY += LineHeight;
            graphics.DrawString("10% SVC", ParagraphFont, BlackColor, startX, startY);
            rect1 = new Rectangle(236, startY, 45, LineHeight);
            graphics.DrawString(_order.ServiceTax.ToString("$ 0.00"), ParagraphFont, BlackColor, rect1, stringFormat);

            startX = 90;
            startY += LineHeight;
            graphics.DrawString("Total", ParagraphFont, BlackColor, startX, startY);
            rect1 = new Rectangle(236, startY, 45, LineHeight);
            graphics.DrawString(_order.Total.ToString("$ 0.00"), ParagraphFont, BlackColor, rect1, stringFormat);

            startY += LineHeight * 2;
            startX = 75;
            graphics.DrawString("Thank you and visit again!", ParagraphFont, BlackColor, startX, startY);
        }

        

        public void PrintToKitchen(Orders Order, string Remarks)
        {
            try
            {
                _order = Order;
                _remarks = Remarks;
                //while (WebSession.CheckPrinterAssigned())
                //{
                //    using (PrintDocument pd = new PrintDocument())
                //    {
                //        PrintDialog dialogPrint = new PrintDialog();
                //        dialogPrint.AllowPrintToFile = true;
                //        dialogPrint.AllowSomePages = true;
                //        dialogPrint.PrinterSettings.MinimumPage = 1;
                //        dialogPrint.PrinterSettings.MaximumPage = 1;
                //        dialogPrint.PrinterSettings.FromPage = 1;
                //        dialogPrint.PrinterSettings.ToPage = 1;
                //        dialogPrint.Document = pd;
                //        pd.PrintPage += new PrintPageEventHandler(pd_PrintKitchenPage);
                //        pd.PrinterSettings.PrinterName = Properties.Settings.Default.KitchenPrinter;
                //        pd.Print();
                //        break;
                //    }
                //}
            }
            catch (Exception ex)
            {
                
            }
        }

        private void pd_PrintKitchenPage(object sender, PrintPageEventArgs ev)
        {
            Graphics graphics = ev.Graphics;
            Brush BlackColor = Brushes.Black;
            Font Headlinefont = new Font("Times New Roman", 18, FontStyle.Regular, GraphicsUnit.Point);
           // Font TitleFont = new Font("Times New Roman", 17, FontStyle.Bold, GraphicsUnit.Point);
            Font TableHeaderFont = new Font("Times New Roman", 13, FontStyle.Regular, GraphicsUnit.Point);
            Font ParagraphFont = new Font("Times New Roman", 11, FontStyle.Regular, GraphicsUnit.Point);
            Pen dashStyle=new Pen(Brushes.Black) { DashStyle = System.Drawing.Drawing2D.DashStyle.Dot };
            int startX = 21;
            int startY = 20;
            int Offset = 10;
            int fWidth = 280;

            Rectangle fullwidth = new Rectangle(Offset, startY, fWidth, 35);
            StringFormat centerSF = new StringFormat();
            centerSF.Alignment = StringAlignment.Center;
            StringFormat rightSF = new StringFormat();
            rightSF.Alignment = StringAlignment.Far;

            //graphics.DrawRectangle(Pens.Black, Offset, startY, fWidth, 35);
            graphics.DrawString("Kitchen Receipt", Headlinefont, BlackColor, fullwidth, centerSF);

            int LineHeight = 19;

            startX = Offset;
            startY = 60;
            graphics.DrawString("Time : " + DateTime.Now.ToString("hh:mm ss tt"), ParagraphFont, BlackColor, startX, startY);

            startX = Offset;
            startY = 80;
            graphics.DrawString("Item", TableHeaderFont, BlackColor, startX, startY);

            startX = 155;
            startY = 80;
            graphics.DrawString("Qty", TableHeaderFont, BlackColor, startX, startY);

            startX = 190;
            graphics.DrawString("Size", TableHeaderFont, BlackColor, startX, startY);

            string ItemName, Qty, Size;
            graphics.DrawLine(dashStyle, new Point(Offset, 108), new Point(287, 108));
            startY = 118;
            
            foreach (OrdersDetails orderdetail in _order.OrdersDetailsList)
            {
                
                ItemName = orderdetail.ProductName.Count() > 20 ? orderdetail.ProductName.Substring(0, 20) + ".." : orderdetail.ProductName;
                Qty = orderdetail.Quantity.ToString();
                Size = "";
                //Guid MeasurementID = WebSession.ProductsList.Where(a => a.UniqueID == orderdetail.ProductID).Select(a => a.ProductMeasurementID).Any() ? WebSession.ProductsList.Where(a => a.UniqueID == orderdetail.ProductID).Select(a => a.ProductMeasurementID).Single() : Guid.Empty;
                //if(!MeasurementID.Equals(Guid.Empty))
                //Size = WebSession.MeasurementList.Where(a => a.UniqueID == MeasurementID).Select(a => a.MeasurementName).Single();
                //Size = Size.Count() > 15 ? Size.Substring(0, 15) + ".." : Size;
                startX = Offset;
                graphics.DrawString(ItemName, ParagraphFont, BlackColor, startX, startY);
                startX += 155;
                graphics.DrawString(Qty, ParagraphFont, BlackColor, startX, startY);
                startX += 35;
                graphics.DrawString(Size, ParagraphFont, BlackColor, startX, startY);
                startY += LineHeight;
            }

            startY += 10;
            graphics.DrawLine(dashStyle, new Point(Offset, startY), new Point(287, startY));

            startY += LineHeight;
            startX = 115;
            graphics.DrawString("Remarks", ParagraphFont, BlackColor, startX, startY);

            startX = Offset;
            startY += 2 * LineHeight;
            graphics.DrawString(_remarks, ParagraphFont, BlackColor, new Rectangle(Offset, startY, 280, 150), StringFormat.GenericTypographic);

        }

    }
}